"use client"

import React from "react";
import { WorkflowButton } from "./workflow.button";
import { TransformedStatewideService } from "../type/transformers";
import { ComponentWithClassName } from "@/types/utils";
import { cn } from "@/lib/utils";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";

export function WorkflowButtonDelete({ data, className }: ComponentWithClassName<{ data: TransformedStatewideService }>) {
  const { setWorkflow } = useApplicationWorkflow()

  return (
    <WorkflowButton
      step="DELETE_SERVICE"
      variant="outline"
      size={"sm"}
      onClick={() => setWorkflow({
        __tag: "DELETE_SERVICE",
        id: data.id,
      })}
      className={cn(
        "hover:bg-destructive hover:text-destructive-foreground focus-within:bg-destructive focus-within:text-destructive-foreground focus-visible:!ring-destructive/30 focus-visible:!border-destructive",
        className
      )}
      aria-label={`Delete service for ${data.agencyId} with name ${data.alias}`}
    >
    </WorkflowButton>
  )
}

